/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.reveng.importData;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.hibernate.Hibernate;
import org.hibernate.Query;
import org.hibernate.Transaction;
import org.hibernate.type.Type;
import sernet.gs.reveng.BaseHibernateDAO;
import sernet.gs.reveng.HibernateSessionFactory;
import sernet.gs.reveng.MSchutzbedarfkategTxt;
import sernet.gs.reveng.MSchutzbedarfkategTxtDAO;
import sernet.gs.reveng.MUmsetzStatTxt;
import sernet.gs.reveng.MbBaust;
import sernet.gs.reveng.MbBaustGefaehr;
import sernet.gs.reveng.MbBaustTxt;
import sernet.gs.reveng.MbDringlichkeitTxt;
import sernet.gs.reveng.MbDringlichkeitTxtDAO;
import sernet.gs.reveng.MbGefaehr;
import sernet.gs.reveng.MbMassn;
import sernet.gs.reveng.MbMassnTxt;
import sernet.gs.reveng.MbRolleTxt;
import sernet.gs.reveng.MbZeiteinheitenTxt;
import sernet.gs.reveng.MbZeiteinheitenTxtDAO;
import sernet.gs.reveng.ModZobjBst;
import sernet.gs.reveng.ModZobjBstId;
import sernet.gs.reveng.ModZobjBstMass;
import sernet.gs.reveng.ModZobjBstMassId;
import sernet.gs.reveng.NZielobjekt;
import sernet.gs.reveng.NZielobjektDAO;
import sernet.gs.reveng.NZielobjektId;
import sernet.gs.reveng.NZobSb;
import sernet.gs.reveng.NZobSbDAO;
import sernet.gs.reveng.NmbNotiz;
import sernet.gs.reveng.importData.BackupFileLocation;
import sernet.gs.reveng.importData.BausteinInformationTransfer;
import sernet.gs.reveng.importData.BausteineMassnahmenResult;
import sernet.gs.reveng.importData.ESAResult;
import sernet.gs.reveng.importData.GSDBConstants;
import sernet.gs.reveng.importData.GefaehrdungInformationTransfer;
import sernet.gs.reveng.importData.MassnahmeInformationTransfer;
import sernet.gs.reveng.importData.NotizenMassnahmeResult;
import sernet.gs.reveng.importData.RAGefaehrdungenResult;
import sernet.gs.reveng.importData.RAGefaehrdungsMassnahmenResult;
import sernet.gs.reveng.importData.ZielobjektTypeResult;
import sernet.gs.reveng.type.Types;

public class GSVampire {
    private static final Logger LOG = Logger.getLogger(GSVampire.class);
    private static final String USER_DEFINED_CONTROL_IDENTIFIER = "bM ";
    List<MSchutzbedarfkategTxt> allSchutzbedarf;
    private static final String QUERY_ZIELOBJEKT_TYP = "select distinct zo, txt.name, subtxt.name \t\t\tfrom NZielobjekt zo, MbZielobjTypTxt txt, MbZielobjSubtypTxt subtxt \t\t\twhere zo.mbZielobjSubtyp.id.zotId = txt.id.zotId \t\t\tand (txt.id.sprId = 0 or txt.id.sprId = 1)\t\t\tand zo.mbZielobjSubtyp.id.zosId = subtxt.id.zosId \t\t\tand (subtxt.id.sprId = 0 or subtxt.id.sprId = 1)         and zo.loeschDatum = null";
    private static final String QUERY_BAUSTEIN_ZIELOBJEKT_MASSNAHME_FOR_ZIELOBJEKT = "select bst, mn, umstxt, zo_bst, obm from ModZobjBstMass obm, \tMUmsetzStatTxt umstxt, \tNZielobjekt zo, \tMbBaust bst, \tMbMassn mn,  ModZobjBst zo_bst  where zo.id.zobImpId = :zobImpId and zo.id.zobId = :zobId and umstxt.id.sprId = 1 and obm.ustId = umstxt.id.ustId and obm.id.zobImpId = zo.id.zobImpId and obm.id.zobId \t= zo.id.zobId and obm.id.bauId \t= bst.id.bauId and obm.id.bauImpId = bst.id.bauImpId and obm.id.masId \t= mn.id.masId and obm.id.masImpId = mn.id.masImpId and zo_bst.id.zobId = zo.id.zobId and zo_bst.id.bauId = bst.id.bauId and obm.loeschDatum = null ";
    private static final String QUERY_NOTIZEN_FOR_ZIELOBJEKT_NAME = "select bst, mn, umstxt, zo_bst, obm, notiz from ModZobjBstMass obm, \tMUmsetzStatTxt umstxt, \tNZielobjekt zo, \tMbBaust bst, \tMbMassn mn,  ModZobjBst zo_bst,  NmbNotiz notiz where zo.name = :name and zo.id.zobImpId = 1 and umstxt.id.sprId = 1 and obm.ustId = umstxt.id.ustId and obm.id.zobImpId = zo.id.zobImpId and obm.id.zobId \t= zo.id.zobId and obm.id.bauId \t= bst.id.bauId and obm.id.bauImpId = bst.id.bauImpId and obm.id.masId \t= mn.id.masId and obm.id.masImpId = mn.id.masImpId and zo_bst.id.zobId = zo.id.zobId and zo_bst.id.bauId = bst.id.bauId and obm.notizId = notiz.id.notizId and obm.loeschDatum = null ";
    private static final String QUERY_BAUSTEIN_NOTIZEN_FOR_ZIELOBJEKT_NAME = "select bst, zo_bst, notiz from ModZobjBst zo_bst,  NZielobjekt zo,  MbBaust bst, NmbNotiz notiz where zo.name = :name and zo.id.zobImpId = 1 and zo_bst.id.zobImpId = zo.id.zobImpId and zo_bst.id.zobId     = zo.id.zobId and zo_bst.id.bauId     = bst.id.bauId and zo_bst.id.bauImpId = bst.id.bauImpId and zo_bst.nmbNotiz.id.notizId = notiz.id.notizId and zo_bst.loeschDatum = null ";
    private static final String QUERY_MITARBEITER_FOR_MASSNAHME = "select mitarbeiter from ModZobjBstMassMitarb obmm, NZielobjekt mitarbeiter where obmm.id.zobImpId = :zobImpId and obmm.id.zobId = :zobId and obmm.id.bauId = :bauId and obmm.id.masId = :masId and obmm.id.zobIdMit = mitarbeiter.id.zobId and obmm.loeschDatum = null";
    private static final String QUERY_MITARBEITER_FOR_BAUSTEIN = "select mitarbeiter \tfrom \t\tModZobjBstMitarb obm, \t\tNZielobjekt mitarbeiter \twhere \t\tobm.id.bauId = :bauId        and obm.id.zobId = :zobId \t\tand obm.id.zobIdMit = mitarbeiter.id.zobId \t\tand obm.loeschDatum = null";
    private static final String QUERY_ROLLE_FOR_MITARBEITER = "select rolle \t\t\tfrom MbRolleTxt rolle, \t\t\t\tNZielobjekt zo, \t\t\t\tNZielobjektRollen zr \t\t\twhere rolle.id.rolId = zr.id.rolId \t\t\tand rolle.id.sprId = 1 \t\t\tand zr.id.zobId = zo.id.zobId \t\t\tand zo.id.zobId = :zobId\t\t\tand zr.loeschDatum = null";
    private static final String QUERY_SCHUTZBEDARF_FOR_ZIELOBJEKT = "select zsb from NZobSb zsb where zsb.id.zobId = :zobId";
    private static final String QUERY_ESA_FOR_ZIELOBJEKT = "select  new sernet.gs.reveng.importData.ESAResult(esa.esaBegruendung, esa.esaEinsatz,  esa.esaModellierung, esa.esaSzenario, esa.msUnj.unjId, esa.esaEntscheidDurch, zmi.name, esa.esaEntscheidDatum, esa.esaRaDatumBis) from NZobEsa esa, NZielobjekt zmi where zmi.id.zobId = esa.esaZobIdMit\tand esa.NZielobjekt.id.zobId = :zobId";
    private static final String QUERY_MBBAUSTTXT_FOR_MBBAUST = "select mbBaustTxt, mzb from MbBaust mbBaust, MbBaustTxt mbBaustTxt, ModZobjBst mzb where mbBaust.id.bauId = mbBaustTxt.id.bauId and mzb.id.bauId = mbBaust.id.bauId and mzb.id.zobId = :zobId and mbBaust.id.bauImpId = 1 and mbBaust.id.bauId = :bstId";
    private static final String QUERY_MBMASSTXT_FOR_MBMASS = "select mbMassnTxt from MbMassn mbMassn, MbMassnTxt mbMassnTxt  where mbMassn.id.masId = mbMassnTxt.id.masId and mbMassn.id.masId = :masId and (mbMassnTxt.id.sprId = 1 or mbMassnTxt.id.sprId = 0)";
    private static final String QUERY_ALLSUBTYPES = "select txt.name, subtxt.name \t\t\tfrom MbZielobjTypTxt txt, MbZielobjSubtypTxt subtxt \t\t\twhere txt.id.sprId = 1 \t\t\tand txt.id.zotId = subtxt.id.zotId \t\t\tand subtxt.id.sprId = 1";
    private static final String QUERY_LINKS_FOR_ZIELOBJEKT = "select dependant \tfrom NZielobjZielobj link, \t\tNZielobjekt dependant \twhere link.id.zobId1 = :zobId \tand link.id.zobId2 = dependant.id.zobId \tand link.loeschDatum = null";
    private static final String QUERY_ZIELOBJEKT_WITH_RA = "select distinct (z), txt.name, subtxt.name from NZielobjekt z, MbZielobjTypTxt txt, MbZielobjSubtypTxt subtxt, RaZobGef rzg where z.mbZielobjSubtyp.id.zotId = txt.id.zotId and (txt.id.sprId = 0 or txt.id.sprId = 1) and z.mbZielobjSubtyp.id.zosId = subtxt.id.zosId and (subtxt.id.sprId = 0 or subtxt.id.sprId = 1) and z.loeschDatum = null and rzg.id.zobId = z.id.zobId";
    private static final String QUERY_RA_GEFS_FOR_ZIELOBJEKT = "select new sernet.gs.reveng.importData.RAGefaehrdungenResult(z, g, gtxt, rabtxt.kurz, rzg) from \tMbGefaehr g, MbGefaehrTxt gtxt,\tRaZobGef rzg, MsRaBehandTxt rabtxt, NZielobjekt z where  rzg.id.zobId = z.id.zobId\tand rzg.id.gefId = g.id.gefId\tand gtxt.id.gefId = g.id.gefId\tand rabtxt.id.rabId = rzg.msRaBehand.rabId\tand z.id.zobId = :zobId\tand (gtxt.id.sprId = 1 or gtxt.id.sprId = 0)\tand rabtxt.id.sprId=1";
    private static final String QUERY_RA_GEF_MNS_FOR_ZIELOBJEKT = "select new sernet.gs.reveng.importData.RAGefaehrdungsMassnahmenResult(z, g, gtxt, rabtxt.kurz, m, mtxt, mzbm, umstxt, stxt) from RaZobGef rzg,    RaZobGefMas rzgma,    MbGefaehr g,    MbGefaehrTxt gtxt,    MsRaBehandTxt rabtxt,    NZielobjekt z,    MbMassn m,    MbMassnTxt mtxt,    ModZobjBstMass mzbm,    MUmsetzStatTxt umstxt,    MbBaustMassnGsiegel mbmg,    MGsiegel s,    MGsiegelTxt stxt where rzg.id.zobId = z.id.zobId    and rzg.id.gefId = g.id.gefId    and gtxt.id.gefId = g.id.gefId    and rabtxt.id.rabId = rzg.msRaBehand.rabId    and m.id.masId = rzgma.id.masId    and rzgma.id.gefId = g.id.gefId    and rzgma.id.zobId = z.id.zobId    and mzbm.id.masId = rzgma.id.masId    and mzbm.id.zobId = z.id.zobId    and mzbm.id.bauImpId = 1    and umstxt.id.ustId = mzbm.ustId    and umstxt.id.sprId = 1    and mtxt.id.masId = m.id.masId    and (gtxt.id.sprId = 1 or gtxt.id.sprId = 0)    and rabtxt.id.sprId=1    and (mtxt.id.sprId = 1 or mtxt.id.sprId = 0)    and mbmg.id.bauId = mzbm.id.bauId    and mbmg.id.masId = mzbm.id.masId    and mbmg.MGsiegel.gruId = s.gruId    and s.gruId = stxt.id.gruId    and stxt.id.sprId=1    and z.id.zobId = :zobId    and g.id.gefId = :gefId ";
    private static final String QUERY_MBBSTGEF_FOR_BAUSTEIN = "select mbg from MbBaustGefaehr mbg, NZielobjekt z, ModZobjBst mzb where mbg.mbBaust.id.bauId = :bstId and mzb.id.bauId = :bstId and mzb.id.zobId = :zobId and z.id.zobId  = :zobId";
    private static final String QUERY_GEFS_FOR_BAUSTEIN = "select mbg.mbGefaehr.nr, mbg.mbGefaehr.id.gefImpId, mbg.mbGefaehr.gfkId, mbg.mbGefaehr.id.gefId, gtxt.name, gtxt.beschreibung, mbg.mbGefaehr.guid from MbGefaehrTxt gtxt, MbBaustGefaehr mbg where mbg.id.gefId = :gefId and gtxt.id.gefId = :gefId and (gtxt.id.sprId = 0 or gtxt.id.sprId = 1)";
    private static final String QUERY_ZOBS_REF_BY_BAUSTEIN = "select nZob.id.zobId from ModZobjBst mZBst, NZielobjekt nZob where mZBst.id.bauId = :bauId and mZBst.refZobId = :refZobId and mZBst.id.zobId = nZob.id.zobId";

    public GSVampire(String configFile) {
        HibernateSessionFactory.setConfigFile(configFile);
    }

    public List<ZielobjektTypeResult> findZielobjektTypAll() {
        return this.findZielobjektTyp(QUERY_ZIELOBJEKT_TYP);
    }

    public List<ZielobjektTypeResult> findZielobjektTypById() {
        return this.findZielobjektTyp(QUERY_ZIELOBJEKT_TYP);
    }

    public List<ZielobjektTypeResult> findZielobjektWithRA() {
        return this.findZielobjektTyp(QUERY_ZIELOBJEKT_WITH_RA);
    }

    public List<ZielobjektTypeResult> findZielobjektTyp(String hql) {
        ArrayList<ZielobjektTypeResult> result = new ArrayList<ZielobjektTypeResult>();
        NZielobjektDAO dao = new NZielobjektDAO();
        Transaction transaction = dao.getSession().beginTransaction();
        Query query = dao.getSession().createQuery(hql);
        Iterator iterate = query.iterate();
        while (iterate.hasNext()) {
            Object[] next = (Object[])iterate.next();
            if (((NZielobjekt)next[0]).getLoeschDatum() != null) continue;
            result.add(new ZielobjektTypeResult((NZielobjekt)next[0], (String)next[1], (String)next[2]));
        }
        transaction.commit();
        dao.getSession().close();
        return result;
    }

    public List<Integer> findReferencedZobsByBaustein(ModZobjBst mZobBst, Integer refZobId) {
        long startTime = System.currentTimeMillis();
        NZielobjektDAO dao = new NZielobjektDAO();
        Transaction transaction = dao.getSession().beginTransaction();
        Query query = dao.getSession().createQuery(QUERY_ZOBS_REF_BY_BAUSTEIN);
        query.setParameter("bauId", (Object)mZobBst.getId().getBauId());
        query.setParameter("refZobId", (Object)refZobId);
        List queryResult = query.list();
        ArrayList<Integer> result = new ArrayList<Integer>(queryResult.size());
        if (!queryResult.contains(mZobBst.getId().getZobId())) {
            for (Object o : queryResult) {
                if (!(o instanceof Integer)) continue;
                result.add((Integer)o);
            }
        }
        transaction.commit();
        dao.getSession().close();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Time computing references for ModZobjBst <" + mZobBst.getId().getBauId() + "|" + mZobBst.getId().getZobId() + ">:\t" + (System.currentTimeMillis() - startTime) / 1000L + "s"));
        }
        return result;
    }

    public List<NotizenMassnahmeResult> findNotizenForZielobjekt(String name) {
        Object[] next;
        ArrayList<NotizenMassnahmeResult> result = new ArrayList<NotizenMassnahmeResult>();
        NZielobjektDAO dao = new NZielobjektDAO();
        Transaction transaction = dao.getSession().beginTransaction();
        Query query = dao.getSession().createQuery(QUERY_NOTIZEN_FOR_ZIELOBJEKT_NAME);
        query.setParameter("name", (Object)name, (Type)Types.STRING_TYPE);
        Iterator iterate = query.iterate();
        while (iterate.hasNext()) {
            next = (Object[])iterate.next();
            result.add(new NotizenMassnahmeResult((MbBaust)next[0], (MbMassn)next[1], (MUmsetzStatTxt)next[2], (ModZobjBst)next[3], (ModZobjBstMass)next[4], (NmbNotiz)next[5]));
        }
        query = dao.getSession().createQuery(QUERY_BAUSTEIN_NOTIZEN_FOR_ZIELOBJEKT_NAME);
        query.setParameter("name", (Object)name, (Type)Types.STRING_TYPE);
        iterate = query.iterate();
        while (iterate.hasNext()) {
            next = (Object[])iterate.next();
            result.add(new NotizenMassnahmeResult((MbBaust)next[0], null, null, (ModZobjBst)next[1], null, (NmbNotiz)next[2]));
        }
        transaction.commit();
        dao.getSession().close();
        return result;
    }

    public List<MbZeiteinheitenTxt> findZeiteinheitenTxtAll() {
        MbZeiteinheitenTxtDAO dao = new MbZeiteinheitenTxtDAO();
        Transaction transaction = dao.getSession().beginTransaction();
        List result = dao.findAll();
        transaction.commit();
        dao.getSession().close();
        return result;
    }

    public List<MSchutzbedarfkategTxt> findSchutzbedarfAll() {
        MSchutzbedarfkategTxtDAO dao = new MSchutzbedarfkategTxtDAO();
        Transaction transaction = dao.getSession().beginTransaction();
        List all = dao.findAll();
        transaction.commit();
        dao.getSession().close();
        return all;
    }

    public List<MbDringlichkeitTxt> findDringlichkeitAll() {
        MbDringlichkeitTxtDAO dao = new MbDringlichkeitTxtDAO();
        Transaction transaction = dao.getSession().beginTransaction();
        List all = dao.findAll();
        transaction.commit();
        dao.getSession().close();
        return all;
    }

    public BausteinInformationTransfer findTxtForMbBaust(MbBaust mbBaust, NZielobjekt z, String encoding) {
        BaseHibernateDAO dao = new BaseHibernateDAO();
        BausteinInformationTransfer bausteininformation = new BausteinInformationTransfer();
        Transaction transaction = dao.getSession().beginTransaction();
        Query qry = dao.getSession().createQuery(QUERY_MBBAUSTTXT_FOR_MBBAUST);
        qry.setParameter("bstId", (Object)mbBaust.getId().getBauId());
        qry.setParameter("zobId", (Object)z.getId().getZobId());
        List hqlResult = qry.list();
        if (hqlResult.size() == 1 && hqlResult.get(0) instanceof Object[]) {
            Object[] resultArr = (Object[])hqlResult.get(0);
            MbBaustTxt mTxt = (MbBaustTxt)resultArr[0];
            ModZobjBst mzb = (ModZobjBst)resultArr[1];
            try {
                bausteininformation.setDescription(mTxt.getBeschreibung() != null ? GSVampire.convertClobToStringEncodingSave(mTxt.getBeschreibung(), encoding) : "no description available");
            }
            catch (IOException e) {
                LOG.error((Object)"Error converting CLOB to String", (Throwable)e);
            }
            bausteininformation.setEncoding(encoding);
            bausteininformation.setId(mbBaust.getNr());
            bausteininformation.setSchicht(String.valueOf(mbBaust.getMbSchicht().getId().getSchId()));
            bausteininformation.setTitel(mTxt.getName());
            bausteininformation.setErfasstAm(mzb.getDatum());
            bausteininformation.setZobId(z.getId().getZobId());
            bausteininformation.setNr(mbBaust.getNr());
            Hibernate.initialize((Object)mzb.getMbBaust());
            Hibernate.initialize((Object)mzb.getNZielobjektByFkZbZ());
            Hibernate.initialize((Object)mzb.getNZielobjektByFkZbZ2());
            bausteininformation.setMzb(mzb);
        }
        transaction.commit();
        dao.getSession().close();
        return bausteininformation;
    }

    public MassnahmeInformationTransfer findTxtforMbMassn(MbMassn mbMassn, String encoding) {
        BaseHibernateDAO dao = new BaseHibernateDAO();
        Transaction transaction = dao.getSession().beginTransaction();
        Query qry = dao.getSession().createQuery(QUERY_MBMASSTXT_FOR_MBMASS);
        qry.setParameter("masId", (Object)mbMassn.getId().getMasId());
        List hqlResult = qry.list();
        MassnahmeInformationTransfer massnahmeinformation = new MassnahmeInformationTransfer();
        if (hqlResult.size() == 1 && hqlResult.get(0) instanceof MbMassnTxt) {
            this.processMassnahme(mbMassn, encoding, hqlResult, massnahmeinformation);
        }
        transaction.commit();
        dao.getSession().close();
        return massnahmeinformation;
    }

    private MassnahmeInformationTransfer processMassnahme(MbMassn mbMassn, String encoding, List<?> hqlResult, MassnahmeInformationTransfer massnahmeinformation) {
        MbMassnTxt mTxt = (MbMassnTxt)hqlResult.get(0);
        massnahmeinformation.setAbstract_(mTxt.getAbstract_());
        massnahmeinformation.setTitel(mTxt.getName());
        try {
            if (mTxt.getBeschreibung() != null) {
                massnahmeinformation.setDescription(GSVampire.convertClobToStringEncodingSave(mTxt.getBeschreibung(), encoding));
            }
            if (mTxt.getHtmltext() != null) {
                massnahmeinformation.setHtmltext(GSVampire.convertClobToStringEncodingSave(mTxt.getHtmltext(), encoding));
            }
        }
        catch (IOException e) {
            LOG.error((Object)"Error parsing clob to String", (Throwable)e);
        }
        String prefix = "";
        if (mbMassn.getUserdef() == GSDBConstants.USERDEF_YES) {
            prefix = USER_DEFINED_CONTROL_IDENTIFIER;
        }
        massnahmeinformation.setId(String.valueOf(prefix) + mbMassn.getMskId() + "." + mbMassn.getNr());
        massnahmeinformation.setSiegelstufe('A');
        massnahmeinformation.setZyklus("-1");
        return massnahmeinformation;
    }

    public GefaehrdungInformationTransfer findGefaehrdungInformationForBausteinGefaehrdung(MbBaustGefaehr mbBstGef, NZielobjekt z, String encoding) {
        BaseHibernateDAO dao = new BaseHibernateDAO();
        Transaction transaction = dao.getSession().beginTransaction();
        Query qry = dao.getSession().createQuery(QUERY_GEFS_FOR_BAUSTEIN);
        qry.setParameter("gefId", (Object)mbBstGef.getMbGefaehr().getId().getGefId());
        List hqlResult = qry.list();
        GefaehrdungInformationTransfer gefaehrdungsInformation = null;
        if (!hqlResult.isEmpty() && hqlResult.get(0) instanceof Object[]) {
            gefaehrdungsInformation = this.processGefaehrdung(encoding, hqlResult);
            gefaehrdungsInformation.setExtId(GSVampire.generateGefaehrdungsUmsetzungExtid(String.valueOf(((Object[])hqlResult.get(0))[0]), String.valueOf(z.getId().getZobId()), String.valueOf(((Object[])hqlResult.get(0))[6]), z.getGuid()));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Setting extId for GefaehrdungsUmsetzung to:\t" + gefaehrdungsInformation.getExtId()));
            }
        }
        this.logDuplicates(encoding, hqlResult);
        transaction.commit();
        dao.getSession().close();
        return gefaehrdungsInformation;
    }

    private GefaehrdungInformationTransfer processGefaehrdung(String encoding, List<?> hqlResult) {
        GefaehrdungInformationTransfer gefaehrdungInformation = new GefaehrdungInformationTransfer();
        Object[] resultArr = (Object[])hqlResult.get(0);
        String gefaehrdungNr = String.valueOf(resultArr[0]);
        String gefaehrdungKapitelId = String.valueOf(resultArr[2]);
        String gefaehrdungName = String.valueOf(resultArr[4]);
        try {
            gefaehrdungInformation.setDescription(GSVampire.convertClobToStringEncodingSave((Clob)resultArr[5], encoding));
        }
        catch (IOException e) {
            LOG.error((Object)"Error parsing clob to String", (Throwable)e);
            gefaehrdungInformation.setDescription("Description not parseable from CLOB");
        }
        gefaehrdungInformation.setId(String.valueOf("bG " + gefaehrdungKapitelId + "." + gefaehrdungNr));
        gefaehrdungInformation.setTitel(gefaehrdungName);
        return gefaehrdungInformation;
    }

    private void logDuplicates(String encoding, List<?> hqlResult) {
        if (LOG.isDebugEnabled() && hqlResult.size() > 1) {
            HashMap<String, String> tMap = new HashMap<String, String>();
            for (Object o : hqlResult) {
                if (o instanceof Object[]) {
                    Object[] oArr = (Object[])o;
                    String gefaehrdungNr = String.valueOf(oArr[0]);
                    String gefaehrdungId = String.valueOf(oArr[3]);
                    String gefaehrdungName = String.valueOf(oArr[4]);
                    String gefaehrdungDescription = "";
                    try {
                        gefaehrdungDescription = GSVampire.convertClobToStringEncodingSave((Clob)oArr[5], encoding);
                    }
                    catch (IOException e) {
                        LOG.error((Object)"Error parsing clob to String", (Throwable)e);
                    }
                    String id = String.valueOf(gefaehrdungId) + gefaehrdungNr + gefaehrdungName;
                    if (tMap.containsKey(id)) {
                        String existingDescription = (String)tMap.get(id);
                        if (!existingDescription.equals(gefaehrdungDescription)) continue;
                        LOG.debug((Object)("<" + id + ">\tDuplicate found:\t" + gefaehrdungDescription));
                        continue;
                    }
                    LOG.debug((Object)("<" + id + ">\tnew desc for existant g:\t" + gefaehrdungDescription));
                    tMap.put(id, gefaehrdungDescription);
                    continue;
                }
                LOG.error((Object)("Unexpected Class of o:\t" + o.getClass().getCanonicalName()));
            }
        }
    }

    public List<MbBaustGefaehr> findGefaehrdungenForBaustein(MbBaust mbBaust, NZielobjekt zo) {
        BaseHibernateDAO dao = new BaseHibernateDAO();
        Transaction transaction = dao.getSession().beginTransaction();
        Query qry = dao.getSession().createQuery(QUERY_MBBSTGEF_FOR_BAUSTEIN);
        qry.setParameter("bstId", (Object)mbBaust.getId().getBauId());
        qry.setParameter("zobId", (Object)zo.getId().getZobId());
        List hqlResult = qry.list();
        transaction.commit();
        dao.getSession().close();
        if (hqlResult != null && !hqlResult.isEmpty()) {
            return hqlResult;
        }
        return Collections.emptyList();
    }

    public Set<NZielobjekt> findVerantowrtlicheMitarbeiterForMassnahme(ModZobjBstMassId id) {
        HashSet<NZielobjekt> result = new HashSet<NZielobjekt>();
        NZielobjektDAO dao = new NZielobjektDAO();
        Transaction transaction = dao.getSession().beginTransaction();
        Query query = dao.getSession().createQuery(QUERY_MITARBEITER_FOR_MASSNAHME);
        query.setProperties((Object)id);
        Iterator iterate = query.iterate();
        while (iterate.hasNext()) {
            result.add((NZielobjekt)iterate.next());
        }
        transaction.commit();
        dao.getSession().close();
        return result;
    }

    public void attachFile(String databaseName, String fileName, String url, String user, String pass) throws SQLException, ClassNotFoundException {
        Class.forName("net.sourceforge.jtds.jdbc.Driver");
        Connection con = DriverManager.getConnection(url, user, pass);
        Statement stmt = con.createStatement();
        try {
            stmt.execute("sp_attach_single_file_db @dbname= N'" + databaseName + "', " + "@physname= N'" + fileName + "'");
        }
        catch (Exception e) {
            try {
                stmt.execute("sp_detach_db '" + databaseName + "'");
            }
            catch (Exception exception) {
                // empty catch block
            }
            stmt.execute("sp_attach_single_file_db @dbname= N'" + databaseName + "', " + "@physname= N'" + fileName + "'");
        }
        stmt.close();
        con.close();
    }

    public BackupFileLocation getBackupFileNames(String databaseName, String fileName, String url, String user, String pass) throws SQLException, ClassNotFoundException {
        BackupFileLocation result = null;
        Class.forName("net.sourceforge.jtds.jdbc.Driver");
        Connection con = DriverManager.getConnection(url, user, pass);
        Statement stmt = con.createStatement();
        try {
            ResultSet rs = stmt.executeQuery("RESTORE FILELISTONLY FROM DISK = '" + fileName + "' ");
            result = new BackupFileLocation();
            if (rs.next()) {
                result.setMdfLogicalName(rs.getString("LogicalName"));
                result.setMdfFileName(rs.getString("PhysicalName"));
            }
            if (rs.next()) {
                result.setLdfLogicalName(rs.getString("LogicalName"));
                result.setLdfFileName(rs.getString("PhysicalName"));
            }
        }
        catch (Exception e) {
            System.err.println(e);
        }
        stmt.close();
        con.close();
        return result;
    }

    public void restoreBackupFile(String databaseName, String fileName, String url, String user, String pass, String mdfName, String mdfFile, String ldfName, String ldfFile) throws SQLException, ClassNotFoundException {
        Class.forName("net.sourceforge.jtds.jdbc.Driver");
        Connection con = DriverManager.getConnection(url, user, pass);
        Statement stmt = con.createStatement();
        try {
            String query = "RESTORE DATABASE " + databaseName + " FROM DISK = '" + fileName + "' " + "WITH MOVE '" + mdfName + "' TO '" + mdfFile + "', MOVE '" + ldfName + "' TO '" + ldfFile + "'";
            stmt.execute(query);
        }
        catch (SQLException e) {
            try {
                stmt.close();
                con.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
        stmt.close();
        con.close();
    }

    public Set<NZielobjekt> findBefragteMitarbeiterForBaustein(ModZobjBstId id) {
        HashSet<NZielobjekt> result = new HashSet<NZielobjekt>();
        NZielobjektDAO dao = new NZielobjektDAO();
        Transaction transaction = dao.getSession().beginTransaction();
        Query query = dao.getSession().createQuery(QUERY_MITARBEITER_FOR_BAUSTEIN);
        query.setProperties((Object)id);
        Iterator iterate = query.iterate();
        while (iterate.hasNext()) {
            result.add((NZielobjekt)iterate.next());
        }
        transaction.commit();
        dao.getSession().close();
        return result;
    }

    public List<BausteineMassnahmenResult> findBausteinMassnahmenByZielobjekt(NZielobjekt zielobjekt) {
        ArrayList<BausteineMassnahmenResult> result = new ArrayList<BausteineMassnahmenResult>();
        NZielobjektDAO dao = new NZielobjektDAO();
        Transaction transaction = dao.getSession().beginTransaction();
        Query query = dao.getSession().createQuery(QUERY_BAUSTEIN_ZIELOBJEKT_MASSNAHME_FOR_ZIELOBJEKT);
        query.setProperties((Object)zielobjekt.getId());
        Iterator iterate = query.iterate();
        while (iterate.hasNext()) {
            Object[] next = (Object[])iterate.next();
            result.add(new BausteineMassnahmenResult((MbBaust)next[0], (MbMassn)next[1], (MUmsetzStatTxt)next[2], (ModZobjBst)next[3], (ModZobjBstMass)next[4]));
            ModZobjBst zobst = (ModZobjBst)next[3];
            if (!LOG.isDebugEnabled() || zobst.getRefZobId() == null) continue;
            LOG.debug((Object)("Baustein Referenz: " + zobst.getRefZobId()));
        }
        transaction.commit();
        dao.getSession().close();
        return result;
    }

    public List<MbRolleTxt> findRollenByZielobjekt(NZielobjekt zielobjekt) {
        ArrayList<MbRolleTxt> result = new ArrayList<MbRolleTxt>();
        NZielobjektDAO dao = new NZielobjektDAO();
        Transaction transaction = dao.getSession().beginTransaction();
        Query query = dao.getSession().createQuery(QUERY_ROLLE_FOR_MITARBEITER);
        query.setProperties((Object)zielobjekt.getId());
        Iterator iterate = query.iterate();
        while (iterate.hasNext()) {
            result.add((MbRolleTxt)iterate.next());
        }
        transaction.commit();
        dao.getSession().close();
        return result;
    }

    public List<NZielobjekt> findLinksByZielobjektId(NZielobjektId zielobjektId) {
        ArrayList<NZielobjekt> result = new ArrayList<NZielobjekt>();
        NZielobjektDAO dao = new NZielobjektDAO();
        Transaction transaction = dao.getSession().beginTransaction();
        Query query = dao.getSession().createQuery(QUERY_LINKS_FOR_ZIELOBJEKT);
        query.setProperties((Object)zielobjektId);
        Iterator iterate = query.iterate();
        while (iterate.hasNext()) {
            result.add((NZielobjekt)iterate.next());
        }
        transaction.commit();
        dao.getSession().close();
        return result;
    }

    public List<NZobSb> findSchutzbedarfByZielobjektId(NZielobjektId zielobjektId) {
        ArrayList<NZobSb> result = new ArrayList<NZobSb>();
        NZobSbDAO dao = new NZobSbDAO();
        Transaction transaction = dao.getSession().beginTransaction();
        Query query = dao.getSession().createQuery(QUERY_SCHUTZBEDARF_FOR_ZIELOBJEKT);
        query.setProperties((Object)zielobjektId);
        Iterator iterate = query.iterate();
        while (iterate.hasNext()) {
            result.add((NZobSb)iterate.next());
        }
        transaction.commit();
        dao.getSession().close();
        return result;
    }

    public MSchutzbedarfkategTxt findSchutzbedarfNameForId(Short zsbVerfuSbkId) {
        if (this.allSchutzbedarf == null) {
            this.allSchutzbedarf = this.findSchutzbedarfAll();
        }
        for (MSchutzbedarfkategTxt kateg : this.allSchutzbedarf) {
            if (kateg.getId().getSprId() != 1 || !kateg.getId().getSbkId().equals(zsbVerfuSbkId)) continue;
            return kateg;
        }
        return null;
    }

    public List<String[]> findSubtypesAll() {
        ArrayList<String[]> result = new ArrayList<String[]>();
        NZielobjektDAO dao = new NZielobjektDAO();
        Transaction transaction = dao.getSession().beginTransaction();
        Query query = dao.getSession().createQuery(QUERY_ALLSUBTYPES);
        Iterator iterate = query.iterate();
        while (iterate.hasNext()) {
            Object[] next = (Object[])iterate.next();
            result.add(new String[]{(String)next[0], (String)next[1]});
        }
        transaction.commit();
        dao.getSession().close();
        return result;
    }

    public List<ESAResult> findESAByZielobjekt(NZielobjekt zielobjekt) {
        ArrayList<ESAResult> result = new ArrayList<ESAResult>();
        NZielobjektDAO dao = new NZielobjektDAO();
        Transaction transaction = dao.getSession().beginTransaction();
        Query query = dao.getSession().createQuery(QUERY_ESA_FOR_ZIELOBJEKT);
        query.setProperties((Object)zielobjekt.getId());
        Iterator iterate = query.iterate();
        while (iterate.hasNext()) {
            result.add((ESAResult)iterate.next());
        }
        transaction.commit();
        dao.getSession().close();
        return result;
    }

    public List<RAGefaehrdungenResult> findRAGefaehrdungenForZielobjekt(NZielobjekt zielobjekt) {
        ArrayList<RAGefaehrdungenResult> result = new ArrayList<RAGefaehrdungenResult>();
        NZielobjektDAO dao = new NZielobjektDAO();
        Transaction transaction = dao.getSession().beginTransaction();
        Query query = dao.getSession().createQuery(QUERY_RA_GEFS_FOR_ZIELOBJEKT);
        query.setProperties((Object)zielobjekt.getId());
        result.addAll(query.list());
        transaction.commit();
        dao.getSession().close();
        return result;
    }

    public List<RAGefaehrdungsMassnahmenResult> findRAGefaehrdungsMassnahmenForZielobjekt(NZielobjekt zielobjekt, MbGefaehr gefaehrdung) {
        ArrayList<RAGefaehrdungsMassnahmenResult> result = new ArrayList<RAGefaehrdungsMassnahmenResult>();
        NZielobjektDAO dao = new NZielobjektDAO();
        Transaction transaction = dao.getSession().beginTransaction();
        Query query = dao.getSession().createQuery(QUERY_RA_GEF_MNS_FOR_ZIELOBJEKT);
        query.setParameter("zobId", (Object)zielobjekt.getId().getZobId());
        query.setParameter("gefId", (Object)gefaehrdung.getId().getGefId());
        result.addAll(query.list());
        transaction.commit();
        dao.getSession().close();
        return result;
    }

    public static String convertClobToStringEncodingSave(Clob clob, String encoding) throws IOException {
        try {
            Reader reader = clob.getCharacterStream();
            ByteArrayInputStream in = new ByteArrayInputStream(IOUtils.toByteArray((Reader)reader, (String)encoding));
            return IOUtils.toString((InputStream)in, (String)encoding);
        }
        catch (Exception e) {
            LOG.error((Object)"Error while converting clob to String", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static String generateGefaehrdungsUmsetzungExtid(String gefaehrdungId, String zielobjektId, String zobGuid, String gefaehrdungGuid) {
        StringBuilder sb = new StringBuilder();
        sb.append(gefaehrdungId);
        sb.append("-");
        sb.append(zielobjektId);
        sb.append("-");
        sb.append(gefaehrdungGuid);
        sb.append("-");
        sb.append(zobGuid);
        return sb.toString();
    }

    public static Object initializeObject(Object object) {
        Hibernate.initialize((Object)object);
        return object;
    }
}

