/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.reveng;

import java.io.Serializable;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.LockMode;
import org.hibernate.Query;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import sernet.gs.reveng.BaseHibernateDAO;
import sernet.gs.reveng.NmbNotiz;
import sernet.gs.reveng.NmbNotizId;

public class NmbNotizDAO
extends BaseHibernateDAO {
    private static final Logger log = Logger.getLogger(NmbNotizDAO.class);
    public static final String NOTIZ_TEXT = "notizText";
    public static final String URL = "url";
    public static final String GUID = "guid";
    public static final String GUID_ORG = "guidOrg";
    public static final String CREATED_BY = "createdBy";
    public static final String CHANGED_BY = "changedBy";

    public void save(NmbNotiz transientInstance) {
        log.debug((Object)"saving NmbNotiz instance");
        try {
            this.getSession().save((Object)transientInstance);
            log.debug((Object)"save successful");
        }
        catch (RuntimeException re) {
            log.error((Object)"save failed", (Throwable)re);
            throw re;
        }
    }

    public void delete(NmbNotiz persistentInstance) {
        log.debug((Object)"deleting NmbNotiz instance");
        try {
            this.getSession().delete((Object)persistentInstance);
            log.debug((Object)"delete successful");
        }
        catch (RuntimeException re) {
            log.error((Object)"delete failed", (Throwable)re);
            throw re;
        }
    }

    public NmbNotiz findById(NmbNotizId id) {
        log.debug((Object)("getting NmbNotiz instance with id: " + id));
        try {
            NmbNotiz instance = (NmbNotiz)this.getSession().get("sernet.gs.reveng.NmbNotiz", (Serializable)id);
            return instance;
        }
        catch (RuntimeException re) {
            log.error((Object)"get failed", (Throwable)re);
            throw re;
        }
    }

    public List findByExample(NmbNotiz instance) {
        log.debug((Object)"finding NmbNotiz instance by example");
        try {
            List results = this.getSession().createCriteria("sernet.gs.reveng.NmbNotiz").add((Criterion)Example.create((Object)instance)).list();
            log.debug((Object)("find by example successful, result size: " + results.size()));
            return results;
        }
        catch (RuntimeException re) {
            log.error((Object)"find by example failed", (Throwable)re);
            throw re;
        }
    }

    public List findByProperty(String propertyName, Object value) {
        log.debug((Object)("finding NmbNotiz instance with property: " + propertyName + ", value: " + value));
        try {
            String queryString = "from NmbNotiz as model where model." + propertyName + "= ?";
            Query queryObject = this.getSession().createQuery(queryString);
            queryObject.setParameter(0, value);
            return queryObject.list();
        }
        catch (RuntimeException re) {
            log.error((Object)"find by property name failed", (Throwable)re);
            throw re;
        }
    }

    public List findByNotizText(Object notizText) {
        return this.findByProperty(NOTIZ_TEXT, notizText);
    }

    public List findByUrl(Object url) {
        return this.findByProperty(URL, url);
    }

    public List findByGuid(Object guid) {
        return this.findByProperty(GUID, guid);
    }

    public List findByGuidOrg(Object guidOrg) {
        return this.findByProperty(GUID_ORG, guidOrg);
    }

    public List findByCreatedBy(Object createdBy) {
        return this.findByProperty(CREATED_BY, createdBy);
    }

    public List findByChangedBy(Object changedBy) {
        return this.findByProperty(CHANGED_BY, changedBy);
    }

    public List findAll() {
        log.debug((Object)"finding all NmbNotiz instances");
        try {
            String queryString = "from NmbNotiz";
            Query queryObject = this.getSession().createQuery(queryString);
            return queryObject.list();
        }
        catch (RuntimeException re) {
            log.error((Object)"find all failed", (Throwable)re);
            throw re;
        }
    }

    public NmbNotiz merge(NmbNotiz detachedInstance) {
        log.debug((Object)"merging NmbNotiz instance");
        try {
            NmbNotiz result = (NmbNotiz)this.getSession().merge((Object)detachedInstance);
            log.debug((Object)"merge successful");
            return result;
        }
        catch (RuntimeException re) {
            log.error((Object)"merge failed", (Throwable)re);
            throw re;
        }
    }

    public void attachDirty(NmbNotiz instance) {
        log.debug((Object)"attaching dirty NmbNotiz instance");
        try {
            this.getSession().saveOrUpdate((Object)instance);
            log.debug((Object)"attach successful");
        }
        catch (RuntimeException re) {
            log.error((Object)"attach failed", (Throwable)re);
            throw re;
        }
    }

    public void attachClean(NmbNotiz instance) {
        log.debug((Object)"attaching clean NmbNotiz instance");
        try {
            this.getSession().lock((Object)instance, LockMode.NONE);
            log.debug((Object)"attach successful");
        }
        catch (RuntimeException re) {
            log.error((Object)"attach failed", (Throwable)re);
            throw re;
        }
    }
}

