/*
 * Decompiled with CFR 0.152.
 */
package sernet.gs.reveng;

import java.net.URL;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.orm.hibernate3.LocalSessionFactoryBean;

public class HibernateSessionFactory {
    private static final Logger LOG = Logger.getLogger(HibernateSessionFactory.class);
    private static final ThreadLocal<Session> threadLocal = new ThreadLocal();
    private static String DEFAULT_CONFIG_FILE_LOCATION = "/hibernate-vampire.cfg.xml";
    private static Resource configLocation = new ClassPathResource(DEFAULT_CONFIG_FILE_LOCATION);
    private static LocalSessionFactoryBean sessionFactoryBean;
    private static SessionFactory sessionFactory;

    private HibernateSessionFactory() {
    }

    static Session getSession() throws HibernateException {
        Session session = threadLocal.get();
        if (session == null || !session.isOpen()) {
            if (sessionFactory == null) {
                HibernateSessionFactory.rebuildSessionFactory();
            }
            session = sessionFactory != null ? sessionFactory.openSession() : null;
            threadLocal.set(session);
        }
        return session;
    }

    private static void rebuildSessionFactory() {
        try {
            Class.forName("net.sourceforge.jtds.jdbc.Driver", true, SessionFactory.class.getClassLoader());
            sessionFactoryBean = new LocalSessionFactoryBean();
            sessionFactoryBean.setConfigLocation(configLocation);
            sessionFactoryBean.setBeanClassLoader(HibernateSessionFactory.class.getClassLoader());
            sessionFactoryBean.afterPropertiesSet();
            sessionFactory = (SessionFactory)sessionFactoryBean.getObject();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("New session factory for GSTOOL import created, configuration file: " + configLocation));
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while rebuilding session factory.", (Throwable)e);
        }
    }

    public static void closeSession() throws HibernateException {
        Session session = threadLocal.get();
        threadLocal.set(null);
        if (session != null) {
            session.close();
        }
    }

    public static SessionFactory getSessionFactory() {
        return sessionFactory;
    }

    private static void setConfigResource(Resource r) {
        if (threadLocal.get() != null) {
            throw new IllegalStateException("A session instance is still available. Close it first!");
        }
        if (sessionFactoryBean != null) {
            sessionFactoryBean.destroy();
            sessionFactoryBean = null;
        }
        sessionFactory = null;
        configLocation = r;
    }

    public static void setConfigFile(String configFile) {
        HibernateSessionFactory.setConfigResource((Resource)new FileSystemResource(configFile));
    }

    public static void setConfigURL(URL url) {
        HibernateSessionFactory.setConfigResource((Resource)new UrlResource(url));
    }
}

