/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.geo.Component2D;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.geo.Polygon;
import org.apache.lucene.geo.Polygon2D;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;

public class LatLonDocValuesPointInPolygonQuery
extends Query {
    private final String field;
    private final Polygon[] polygons;

    LatLonDocValuesPointInPolygonQuery(String field, Polygon ... polygons) {
        if (field == null) {
            throw new IllegalArgumentException("field must not be null");
        }
        if (polygons == null) {
            throw new IllegalArgumentException("polygons must not be null");
        }
        if (polygons.length == 0) {
            throw new IllegalArgumentException("polygons must not be empty");
        }
        for (int i = 0; i < polygons.length; ++i) {
            if (polygons[i] != null) continue;
            throw new IllegalArgumentException("polygon[" + i + "] must not be null");
        }
        this.field = field;
        this.polygons = polygons;
    }

    @Override
    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        if (!this.field.equals(field)) {
            sb.append(this.field);
            sb.append(':');
        }
        sb.append("polygons(").append(Arrays.toString(this.polygons));
        return sb.append(")").toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (!this.sameClassAs(obj)) {
            return false;
        }
        LatLonDocValuesPointInPolygonQuery other = (LatLonDocValuesPointInPolygonQuery)obj;
        return this.field.equals(other.field) && Arrays.equals(this.polygons, other.polygons);
    }

    @Override
    public int hashCode() {
        int h = this.classHash();
        h = 31 * h + this.field.hashCode();
        h = 31 * h + Arrays.hashCode(this.polygons);
        return h;
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.field)) {
            visitor.visitLeaf(this);
        }
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, final float boost) throws IOException {
        return new ConstantScoreWeight(this, boost){
            final Component2D tree;
            final GeoEncodingUtils.PolygonPredicate polygonPredicate;
            {
                super(query, score);
                this.tree = Polygon2D.create(LatLonDocValuesPointInPolygonQuery.this.polygons);
                this.polygonPredicate = GeoEncodingUtils.createComponentPredicate(this.tree);
            }

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                final SortedNumericDocValues values = context.reader().getSortedNumericDocValues(LatLonDocValuesPointInPolygonQuery.this.field);
                if (values == null) {
                    return null;
                }
                TwoPhaseIterator iterator = new TwoPhaseIterator(values){

                    @Override
                    public boolean matches() throws IOException {
                        int count = values.docValueCount();
                        for (int i = 0; i < count; ++i) {
                            int lon;
                            long value = values.nextValue();
                            int lat = (int)(value >>> 32);
                            if (!polygonPredicate.test(lat, lon = (int)(value & 0xFFFFFFFFFFFFFFFFL))) continue;
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public float matchCost() {
                        return 1000.0f;
                    }
                };
                return new ConstantScoreScorer((Weight)this, boost, scoreMode, iterator);
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return DocValues.isCacheable(ctx, LatLonDocValuesPointInPolygonQuery.this.field);
            }
        };
    }
}

